// AISingleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AISingle.h"
#include "AISingleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAISingleDlg dialog

CAISingleDlg::CAISingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAISingleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAISingleDlg)
	m_result = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAISingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAISingleDlg)
	DDX_Control(pDX, IDC_Sample, m_SampleButton);
	DDX_Text(pDX, IDC_Result, m_result);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAISingleDlg, CDialog)
	//{{AFX_MSG_MAP(CAISingleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_BN_CLICKED(IDC_Sample, OnSample)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAISingleDlg message handlers

BOOL CAISingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAISingleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAISingleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAISingleDlg::OnInit() 
{
   // Open the driver and Initialize the hardware
m_pSR=NULL;
m_driverInstance=NULL;
// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"c:\\drvlinx4\\kmbdas16.dll"); //Open DriverLINX driver
// put name of your driver to avoid OpenDriverLINX dialog box
// change name of driver to work with another board
// only the DAS-16/1600 and DAS-8 require a path name
// all KPCI cards, just pass driver name such as kpci3100 for KPCI-3101
//
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=0; //set the device number to the device being used
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_SampleButton.EnableWindow(TRUE);  // enable the Sample button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}
	
}

void CAISingleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CAISingleDlg::OnSample() 
{
	// setup a single channel, polled mode AI task
	m_pSR->device = 0;
	m_pSR->hWnd = m_hWnd;
	m_pSR->mode = POLLED;
	m_pSR->operation = START;
	m_pSR->subsystem = AI;
	m_pSR->start.typeEvent = COMMAND;
	m_pSR->stop.typeEvent = TCEVENT;
	m_pSR->timing.typeEvent = NULLEVENT;
	m_pSR->channels.nChannels = 1;
	m_pSR->channels.chanGain[0].channel = 0;
	m_pSR->channels.chanGain[0].gainOrRange = Gain2Code(0,AI,-1); // board configured
	// for -10 to +10 VDC range, e.g., all gain switches on OFF position

	m_pSR->channels.numberFormat = tNATIVE;
	if (DriverLINX(m_pSR) == NoErr)  // carry out task and error check
	{  // success
		float volts;
		int result;
		result = Code2Volts(0,AI,m_pSR->status.u.ioValue,&volts);
		// Code2Volts function always assumes -10 to +10 volt range was used
		// for other ranges, apply appropriate conversion or
		// use a convert operation to have a gain aware conversion between
		// A/D counts to volts
		m_result.Format("%8.3f",volts);
		UpdateData(FALSE); // update the Dialog
	}
    else
	{  // problem has occured
     showMessage(m_pSR);  // display the error message box
	}

	
}

void CAISingleDlg::OnClose() 
{
// TODO: Add your message handler code here and/or call default
	
	// code to clean up after DriverLINX
CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
delete(m_pSR); //de-allocate the memory used by the service request
m_pSR=NULL;
// pass message on to the dialog
	CDialog::OnClose();
}
